#!/usr/local/bin/perl
# edit_acl.cgi
# Display a form for editing the access control options for some module

require './acl-lib.pl';
&ReadParse();
$access{'acl'} || &error($text{'acl_emod'});
if ($in{'group'}) {
	$access{'groups'} || &error($text{'acl_egroup'});
	$who = $in{'group'};
	}
else {
	foreach $u (&list_users()) {
		$me = $u if ($u->{'name'} eq $ENV{'REMOTE_USER'});
		}
	@mcan = $access{'mode'} == 1 ? @{$me->{'modules'}} :
		$access{'mode'} == 2 ? split(/\s+/, $access{'mods'}) :
				       ( &list_modules() , "" );
	&indexof($in{'mod'}, @mcan) >= 0 || &error($text{'acl_emod'});
	&can_edit_user($in{'user'}) || &error($text{'acl_euser'});
	$who = $in{'user'};
	}

&header($text{'acl_title'}, "", -r &help_file($in{'mod'}, "acl_info") ?
	[ "acl_info", $in{'mod'} ] : undef);
%minfo = $in{'mod'} ? &get_module_info($in{'mod'})
		    : ( 'desc' => $text{'index_global'} );
print "<center><font size=+1>",
      &text($in{'group'} ? 'acl_title3' : 'acl_title2', "<tt>$who</tt>",
	    "<tt>$minfo{'desc'}</tt>"),"</font></center>\n";
print "<hr>\n";
%access = &get_module_acl($who, $in{'mod'});

# display the form
print "<form method=post action=save_acl.cgi>\n";
print "<input type=hidden name=_acl_mod value=$in{'mod'}>\n";
if ($in{'group'}) {
	print "<input type=hidden name=_acl_group value=$who>\n";
	}
else {
	print "<input type=hidden name=_acl_user value=$who>\n";
	}
print "<table border width=100%>\n";
print "<tr $tb> <td><b>",&text('acl_options', $minfo{'desc'}),
      "</b></td> </tr>\n";
print "<tr $cb> <td><table width=100%>\n";

if ($in{'mod'}) {
	print "<tr> <td><b>$text{'acl_config'}</b></td> <td>\n";
	printf "<input type=radio name=noconfig value=0 %s> $text{'yes'}\n",
		$access{'noconfig'} ? "" : "checked";
	printf "<input type=radio name=noconfig value=1 %s> $text{'no'}</td>\n",
		$access{'noconfig'} ? "checked" : "";
	print "<td width=50% colspan=2></td> </tr>\n";
	}

if (-r "../$in{'mod'}/acl_security.pl") {
	print "<tr> <td colspan=4><hr></td> </tr>\n" if ($in{'mod'});
	&foreign_require($in{'mod'}, "acl_security.pl");
	&foreign_call($in{'mod'}, "acl_security_form", \%access);
	}

print "</table></td></tr></table>\n";
print "<input type=submit value=\"$text{'save'}\"></form>\n";
print "<hr>\n";
&footer("", $text{'index_return'});

