# log_parser.pl
# Functions for parsing this module's logs

require './acl-lib.pl';

# parse_webmin_log(user, script, action, type, object, &params)
# Converts logged information from this module into human-readable form
sub parse_webmin_log
{
local ($user, $script, $action, $type, $object, $p) = @_;
local $g = $type eq 'group' ? "_g" : "";
if ($action eq 'modify') {
	if ($p->{'old'} ne $p->{'name'}) {
		return &text('log_rename'.$g, "<tt>$p->{'old'}</tt>",
					      "<tt>$p->{'name'}</tt>");
		}
	else {
		return &text('log_modify'.$g, "<tt>$object</tt>");
		}
	}
elsif ($action eq 'create') {
	if ($p->{'clone'}) {
		return &text('log_clone'.$g, "<tt>$p->{'clone'}</tt>",
					     "<tt>$object</tt>");
		}
	else {
		return &text('log_create'.$g, "<tt>$object</tt>");
		}
	}
elsif ($action eq 'delete') {
	return &text('log_delete'.$g, "<tt>$object</tt>");
	}
elsif ($action eq 'acl') {
	return &text('log_acl', "<tt>$object</tt>", "<i>$p->{'moddesc'}</i>");
	}
elsif ($action eq 'cert') {
	return &text('log_cert', "<tt>$object</tt>");
	}
else {
	return undef;
	}
}

