#!/usr/local/bin/perl
# create_forward.cgi
# Create a new forward zone

require './bind8-lib.pl';
&ReadParse();
&error_setup($text{'fcreate_err'});
%access = &get_module_acl();
$access{'forward'} || &error($text{'fcreate_ecannot'});
$access{'ro'} && &error($text{'master_ero'});
$conf = &get_config();

# validate inputs
if ($in{'rev'}) {
	local($ipv4);
	($ipv4 = &check_net_ip($in{'zone'})) ||
	$config{'support_aaaa'} &&
	(($in{'zone'} =~ /^([\w:]+)(\/\d+)$/) || &check_ip6address($1)) ||
		&error(&text('create_enet', $in{'zone'}));
	if ($ipv4) {
		$in{'zone'} = &ip_to_arpa($in{'zone'});
		}
	else {
		$in{'zone'} = &net_to_ip6int($1, ($2 ? substr($2, 1) : "" ));
		}
	}
else {
	($in{'zone'} =~ /^[\d\.]+$/ || $in{'zone'} =~ /^[\d\:]+(\/[\d]+)?$/) &&
		&error(&text('create_edom2', $in{'zone'}));
	&valdnsname($in{'zone'}, 0, ".") ||
		&error(&text('create_edom', $in{'zone'}));
	}
$in{'zone'} =~ s/\.$//;
@masters = split(/\s+/, $in{'masters'});
foreach $m (@masters) {
	&check_ipaddress($m) ||
		&error(&text('create_emaster', $m));
	}
if (!@masters) {
	&error($text{'create_enone'});
	}
foreach $z (&find("zone", $conf)) {
	if ($z->{'value'} eq $in{'zone'}) {
		&error($text{'master_etaken'});
		}
	}

# Create zone directive
&lock_file($config{'chroot'}.$config{'named_conf'});
open(CONF, ">>$config{'chroot'}$config{'named_conf'}");
print CONF "zone \"$in{'zone'}\" {\n";
print CONF "\ttype forward;\n";
print CONF "\tforwarders {\n";
foreach $m (@masters) { print CONF "\t\t$m;\n"; }
print CONF "\t\t};\n";
print CONF "\t};\n";
print CONF "\n";
close(CONF);
&unlock_file($config{'chroot'}.$config{'named_conf'});
&webmin_log("create", "forward", $in{'zone'}, \%in);

# Add the new zone to the access list
if ($access{'zones'} ne '*') {
	$access{'zones'} .= " ".$in{'zone'};
	&save_module_acl(\%access);
	}
&redirect("edit_forward.cgi?index=".scalar(@$conf));

