#!/usr/local/bin/perl
# dns_boot.cgi
# Create an empty named.conf file and start the name server

require './bind8-lib.pl';
&error_setup($text{'boot_err'});
&ReadParse();

$config{'named_conf'} =~ /^(\S+)\/([^\/]+)$/;
$conf_directory = $1;

&lock_file($config{'chroot'}.$config{'named_conf'});
&lock_file("$config{'chroot'}$conf_directory/db.cache");
$conf_temp = &tempname("webmin.named.conf");
open(BOOT, ">$conf_temp");
print BOOT "options {\n";
print BOOT "\tdirectory \"$conf_directory\";\n";
print BOOT "\tpid-file \"/var/run/named.pid\";\n";
print BOOT "\t};\n";
print BOOT "\n";
mkdir("/var/run", 0755);
if ($in{real} == 0) {
	# Create an empty root domain file... no need to do anything here
	}
elsif ($in{real} == 1) {
	# Try to download the root servers file from
	# ftp://rs.internic.net/domain/named.root
	&ftp_download("rs.internic.net", "/domain/named.root", 
		      "$config{'chroot'}$conf_directory/db.cache");
	print BOOT "zone \".\" {\n";
	print BOOT "\ttype hint;\n";
	print BOOT "\tfile \"$conf_directory/db.cache\";\n";
	print BOOT "\t};\n";
	print BOOT "\n";
	}
elsif ($in{real} == 2) {
	# Use builtin db.cache
	system("cp ./db.cache $config{'chroot'}$conf_directory/db.cache 2>/dev/null");
	print BOOT "zone \".\" {\n";
	print BOOT "\ttype hint;\n";
	print BOOT "\tfile \"$conf_directory/db.cache\";\n";
	print BOOT "\t};\n";
	print BOOT "\n";
	}
close(BOOT);
system("cp $conf_temp $config{'chroot'}$config{'named_conf'} 2>/dev/null");
unlink($conf_temp);
&unlock_file("$config{'chroot'}$conf_directory/db.cache");
&unlock_file($config{'chroot'}.$config{'named_conf'});
&set_ownership("$config{'chroot'}$conf_directory/db.cache")
	if ($in{'real'} == 2 || $in{'real'} == 1);
&set_ownership($config{'chroot'}.$config{'named_conf'});
&webmin_log("boot");
&redirect("start.cgi");

