#!/usr/local/bin/perl
# save_slave.cgi
# Save changes to slave zone options in named.conf

require './bind8-lib.pl';
&ReadParse();
$zconf = &get_config()->[$in{'index'}];
&lock_file($config{'chroot'}.$zconf->{'file'});
&error_setup($text{'slave_err'});
%access = &get_module_acl();
&can_edit_zone(\%access, $zconf->{'value'}) ||
	&error($text{'slave_ecannot'});
$access{'ro'} && &error($text{'master_ero'});

&save_address("masters", $zconf, 1);
&save_opt("max-transfer-time-in", \&mtti_check, $zconf, 1);
&save_opt("file", \&file_check, $zconf, 1);
&save_choice("check-names", $zconf, 1);
&save_choice("notify", $zconf, 1);
&save_addr_match("allow-update", $zconf, 1);
&save_addr_match("allow-transfer", $zconf, 1);
&save_addr_match("allow-query", $zconf, 1);
&save_address("also-notify", $zconf, 1);
&flush_file_lines();
&unlock_file($config{'chroot'}.$zconf->{'file'});
&webmin_log("opts", undef, $zconf->{'value'}, \%in);
&redirect("");

sub mtti_check
{
return $_[0] =~ /^\d+$/ ? undef : &text('slave_emax', $_[0]);
}

sub file_check
{
return $text{'slave_efile'} if ($_[0] !~ /\S/);
local $file = $_[0];
if ($_[0] !~ /^\//) {
	$file = &base_directory($conf)."/".$file;
	}
return &allowed_zone_file(\%access, $file) ? undef :
	&text('slave_efile2', $_[0]);
}

