#!/usr/local/bin/perl
# download.cgi
# Get a perl module from somewhere

require './cpan-lib.pl';
&ReadParseMime();

if ($ENV{REQUEST_METHOD} eq "POST") { &ReadParseMime(); }
else { &ReadParse(); $no_upload = 1; }
&error_setup($text{'download_err'});

&tempname();
if ($in{'source'} == 0) {
	# installing from local file (or maybe directory)
	if (!$in{'local'})
		{ &error($text{'download_elocal'}); }
	if (!-r $in{'local'})
		{ &error(&text('download_elocal2', $in{'local'})); }
	$source = $in{'local'};
	$pfile = $in{'local'};
	$need_unlink = 0;
	}
elsif ($in{'source'} == 1) {
	# installing from upload .. store file in temp location
	if ($no_upload) {
		&error($text{'download_eupload'});
		}
	$in{'upload_filename'} =~ /([^\/]+$)/;
	$pfile = &tempname("$1");
	open(PFILE, "> $pfile");
	print PFILE $in{'upload'};
	close(PFILE);
	$source = $in{'upload_filename'};
	$need_unlink = 1;
	}
elsif ($in{'source'} == 2) {
	# installing from URL.. store downloaded file in temp location
	$in{'url'} =~ /\/([^\/]+)\/*$/;
	$pfile = &tempname("$1");
	if ($in{'url'} =~ /^http:\/\/([^\/]+)(\/.*)$/) {
		# Make a HTTP request
		$host = $1; $page = $2; $port = 80;
		if ($host =~ /^(.*):(\d+)$/) { $host = $1; $port = $2; }
		&http_download($host, $port, $page, $pfile);
		}
	elsif ($in{'url'} =~ /^ftp:\/\/([^\/]+)(\/.*)$/) {
		$host = $1; $file = $2;
		&ftp_download($host, $file, $pfile);
		}
	else { &error(&text('download_eurl', $in{'url'})); }
	$source = $in{'url'};
	$need_unlink = 1;
	}
elsif ($in{'source'} == 3) {
	# installing from CPAN.. find the module, and then install it
	if (!-r $packages_file || $in{'refresh'}) {
		# Need to download the modules list from CPAN first
		&download_packages_file();
		}

	# Find the module in the modules list
	open(LIST, "gunzip -c $packages_file |");
	while(<LIST>) {
		s/\r|\n//g;
		if ($_ eq '') { $found_blank++; }
		elsif ($found_blank && /^(\S+)\s+(\S+)\s+(.*)/) {
			if ($1 eq $in{'cpan'}) {
				$source = "$config{'cpan'}/$3";
				last;
				}
			}
		}
	close(LIST);
	$source || &error(&text('download_ecpan', "<tt>$in{'cpan'}</tt>"));

	# Download the actual module
	$source =~ /\/([^\/]+)\/*$/;
	$pfile = &tempname("$1");
	if ($source =~ /^http:\/\/([^\/]+)(\/.*)$/) {
		# Make a HTTP request
		$host = $1; $page = $2; $port = 80;
		if ($host =~ /^(.*):(\d+)$/) { $host = $1; $port = $2; }
		&http_download($host, $port, $page, $pfile);
		}
	elsif ($source =~ /^ftp:\/\/([^\/]+)(\/.*)$/) {
		$host = $1; $file = $2;
		&ftp_download($host, $file, $pfile);
		}
	else { &error(&text('download_eurl', $in{'url'})); }
	$need_unlink = 1;
	}

# Check if the file looks like a perl module
open(TAR, "( gunzip -c $pfile | tar tf - ) 2>&1 |");
while($line = <TAR>) {
	if ($line =~ /^\.\/([^\/]+)\/(.*)$/ || $line =~ /^([^\/]+)\/(.*)$/) {
		$mods{$1}++;
		$file{$2}++;
		}
	$tar .= $line;
	}
close(TAR);
if ($?) {
	&error(&text('download_etar', "<tt>$tar</tt>"));
	unlink($pfile) if ($need_unlink);
	}
@mods = keys %mods;
if (@mods != 1 || !$file{'Makefile.PL'} || $mods[0] !~ /^(\S+)\-([0-9\.]+)$/) {
	&error($text{'download_emod'});
	unlink($pfile) if ($need_unlink);
	}
$mod = $1; $ver = $2;
$mod =~ s/-/::/g;

# Display install options
&header($text{'download_title'}, "");
print "<hr>\n";

print "<form action=install.cgi>\n";
print "<input type=hidden name=source value='$source'>\n";
print "<input type=hidden name=need_unlink value='$need_unlink'>\n";
print "<input type=hidden name=pfile value='$pfile'>\n";
print "<input type=hidden name=mod value='$mod'>\n";
print "<input type=hidden name=ver value='$ver'>\n";
print "<input type=hidden name=dir value='$mods[0]'>\n";
print "<table border>\n";
print "<tr $tb> <td><b>$text{'download_header'}</b></td> </tr>\n";
print "<tr $cb> <td><table>\n";

print "<tr> <td><b>$text{'download_mod'}</b></td> <td>$mod</td> </tr>\n";
print "<tr> <td><b>$text{'download_ver'}</b></td> <td>$ver</td> </tr>\n";
print "<tr> <td><b>$text{'download_src'}</b></td> <td>$source</td> </tr>\n";
print "<tr> <td><b>$text{'download_act'}</b></td> <td><select name=act>\n";
print "<option value=0> $text{'download_m'}\n";
print "<option value=1> $text{'download_mt'}\n";
print "<option value=2> $text{'download_mi'}\n";
print "<option value=3 selected> $text{'download_mti'}\n";
print "</select></td> </tr>\n";

print "<tr> <td><b>$text{'download_args'}</b></td>\n";
print "<td><input name=args size=40></td> </tr>\n";

print "</table></td></tr></table>\n";
print "<input type=submit value='$text{'download_cont'}'></form>\n";

print "<hr>\n";
&footer("", $text{'index_return'});


