
require './file-lib.pl';

# acl_security_form(&options)
# Output HTML for editing security options for the file module
sub acl_security_form
{
print "<tr> <td><b>$text{'acl_user'}</b></td>\n";
local $u = $_[0]->{'uid'} < 0 ? '' : getpwuid($_[0]->{'uid'});
printf "<td><input type=radio name=uid_def value=1 %s> %s\n",
	$_[0]->{'uid'} < 0 ? 'checked' : '', $text{'acl_user_def'};
printf "<input type=radio name=uid_def value=0 %s>\n",
	$_[0]->{'uid'} < 0 ? '' : 'checked';
print "<input name=uid size=8 value='$u'> ",
	&user_chooser_button("uid", 0),"</td> </tr>\n";

print "<tr> <td><b>$text{'acl_umask'}</b></td>\n";
print "<td><input name=umask size=3 value='$_[0]->{'umask'}'></td> </tr>\n";

print "<tr> <td><b>$text{'acl_follow'}</b></td> <td>\n";
printf "<input type=radio name=follow value=1 %s> $text{'yes'}\n",
	$_[0]->{'follow'} ? "checked" : "";
printf "<input type=radio name=follow value=0 %s> $text{'no'}</td> </tr>\n",
	$_[0]->{'follow'} ? "" : "checked";

print "<tr> <td valign=top><b>$text{'acl_dirs'}</b></td>\n";
print "<td><textarea name=root rows=3 cols=30>",
	join("\n", split(/\s+/, $_[0]->{'root'})),"</textarea><br>\n";
printf "<input type=checkbox name=home value=1 %s> %s</td> </tr>\n",
	$_[0]->{'home'} ? 'checked' : '', $text{'acl_home'};
}

# acl_security_save(&options)
# Parse the form for security options for the file module
sub acl_security_save
{
$_[0]->{'uid'} = $in{'uid_def'} ? -1 : getpwnam($in{'uid'});
local @root = split(/\s+/, $in{'root'});
map { s/\/+/\//g } @root;
map { s/([^\/])\/+$/$1/ } @root;
$_[0]->{'root'} = join(" ", @root);
$_[0]->{'follow'} = $in{'follow'};
$in{'umask'} =~ /^[0-7]{3}$/ || &error("Invalid umask");
$_[0]->{'umask'} = $in{'umask'};
$_[0]->{'home'} = $in{'home'};
}

