#!/usr/local/bin/perl
# index.cgi
# Display GRUB menu titles

require './grub-lib.pl';
&header($text{'index_title'}, "", undef, 1, 1, 0,
	&help_search_link("grub", "man", "doc"));
print "<hr>\n";

# Check that GRUB is installed
if (!-r $config{'menu_file'}) {
	print "<p>",&text('index_efile', "<tt>$config{'menu_file'}</tt>",
			  "/config.cgi?$module_name"),"<p>\n";
	print "<hr>\n";
	&footer("/", $text{'index'});
	exit;
	}
if (!-x $config{'grub_path'}) {
	print "<p>",&text('index_epath', "<tt>$config{'grub_path'}</tt>",
			  "/config.cgi?$module_name"),"<p>\n";
	print "<hr>\n";
	&footer("/", $text{'index'});
	exit;
	}

# List the boot options
$conf = &get_menu_config();
$def = &find_value("default", $conf);
foreach $t (&find("title", $conf)) {
	push(@icons, $t->{'chainloader'} ? "images/chain.gif"
					 : "images/kernel.gif");
	push(@titles, $def == $i ? "<b>$t->{'value'}</b>" : $t->{'value'});
	push(@links, "edit_title.cgi?idx=$t->{'index'}");
	$i++;
	}
if (@links) {
	&icons_table(\@links, \@titles, \@icons, 4);
	}
else {
	print "<b>$text{'index_none'}</b><p>\n";
	}
print "<a href='edit_title.cgi?new=1'>$text{'index_add'}</a><p>\n";
print "<hr>\n";

print "<table width=100%>\n";
print "<form action=edit_global.cgi>\n";
print "<tr><td><input type=submit value=\"$text{'index_global'}\"></td>\n";
print "<td>$text{'index_globalmsg'}</td></tr></form>\n";

%flang = &load_language('fdisk');
$text{'select_part'} = $flang{'select_part'};
$text{'select_device'} = $flang{'select_device'};
$text{'select_fd'} = $flang{'select_fd'};
$r = $config{'install'};
$dev = $r =~ /^\(fd(\d+)\)$/ ? &text('select_fd', $1) :
       $r =~ /^\(hd([0-3])\)$/ ? &text('select_device', 'IDE', uc(chr($1+97))) :
       $r =~ /^\(hd([0-3]),([0-7])\)$/ ? &text('select_part', 'IDE',
					       uc(chr($1+97)), $2) : $r;
print "<form action=install.cgi>\n";
print "<input type=hidden name=dev value='$dev'>\n";
print "<tr><td><input type=submit value=\"$text{'index_install'}\"></td>\n";
print "<td>",&text('index_installmsg', $dev),"</td></tr></form>\n";

print "</table>\n";

print "<hr>\n";
&footer("/", $text{'index'});

