#!/usr/local/bin/perl
# install.cgi
# Install the GRUB boot loader

require './grub-lib.pl';
&error_setup($text{'install_err'});
&ReadParse();

# Ask grub where the menu.lst file is
$temp = &tempname();
open(TEMP, ">$temp");
print TEMP "find $config{'menu_file'}\n";
close(TEMP);
open(GRUB, "$config{'grub_path'} --batch <$temp |");
while(<GRUB>) {
	if (/find\s+(\S+)/ && $1 eq $config{'menu_file'}) {
		$out .= $_;
		$_ = <GRUB>;
		if (/^\s*(\(\S+\))/) {
			$root = $1;
			}
		}
	$out .= $_;
	}
close(GRUB);
unlink($temp);
if (!$root || $?) {
	# Didn't find it!
	&error($text{'install_efind'},"<pre>",$out,"</pre>");
	}

# Setup on the chosen device
&header($text{'install_title'}, "");
print "<hr>\n";
print &text('install_desc', $in{'dev'}, "<tt>root $root</tt>",
	    "<tt>setup $config{'install'}</tt>"),"<p>\n";
print "<pre>";
open(TEMP, ">$temp");
print TEMP "root $root\n";
print TEMP "setup $config{'install'}\n";
close(TEMP);
open(GRUB, "$config{'grub_path'} --batch <$temp |");
while(<GRUB>) {
	if (/\d+\s+sectors\s+are\s+embedded/i) {
		$embedded++;
		}
	elsif (/error/) {
		$error++;
		}
	print $_;
	}
close(GRUB);
print "</pre>\n";
if (!$embedded || $? || $error) {
	print "$text{'install_failed'}<p>\n";
	}
else {
	print "$text{'install_ok'}<p>\n";
	}

print "<hr>\n";
&footer("", $text{'index_return'});

