#!/usr/local/bin/perl
# index.cgi
# Displays a list of all PAP secrets

require './pap-lib.pl';
&header($text{'index_title'}, "", undef, 1, 1);
print "<hr>\n";

if (!(-r $config{'pap_file'})) {
	print "<b>", &text('index_enopfile', $config{'pap_file'}), "</b>.<p>\n";
	print "<hr>\n";
	&footer("/", $text{'index_return'});
	exit;
	}

@sec = &list_secrets();
print "<table border width=100%>\n";
print "<tr $tb> <td><b>", $text{'index_table'}, "</b></td> </tr>\n";
print "<tr $cb> <td><table width=100%>\n";
print "<tr> <td width=25%><b>", $text{'index_user'}, "</b></td> ",
      "<td width=25%><b>", $text{'index_server'}, "</b></td> ",
      "<td width=25%><b>", $text{'index_user'}, "</b></td> ",
      "<td width=25%><b>", $text{'index_server'}, "</b></td> </tr>\n";
for($i=0; $i<@sec; $i++) {
	if ($i%2 == 0) { print "<tr>\n"; }
	$s = $sec[$i];
	printf "<td width=25%><a href=\"edit_secret.cgi?$i\">%s</a></td>\n",
		$s->{'client'} ? $s->{'client'} : $text{'index_uany'};
	printf "<td width=25%>%s</td>\n",
		$s->{'server'} eq "*" ? $text{'index_sany'} : $s->{'server'};
	if ($i%2 == 1) { print "</tr>\n"; }
	}
print "</table></td></tr></table>\n";
print "<a href=\"edit_secret.cgi\">", $text{'index_create'}, "</a>.<p>\n";

print "<hr>\n", $text{'index_info'}, " <p>\n";

print "<form action=save_sync.cgi>\n";
printf "<input type=checkbox name=add value=1 %s>\n",
	$config{'sync_add'} ? "checked" : "";
print $text{'index_onadd'}, "\n";
print "<input name=server size=20 value=\"$config{'sync_server'}\"><p>\n";

printf "<input type=checkbox name=change value=1 %s>\n",
	$config{'sync_change'} ? "checked" : "";
print $text{'index_onchange'}, "<p>\n";

printf "<input type=checkbox name=delete value=1 %s>\n",
	$config{'sync_delete'} ? "checked" : "";
print $text{'index_ondelete'}, "<p>\n";
print "<input type=submit value=", $text{'index_apply'}, "></form>\n";

print "<hr>\n";
&footer("/", $text{'index_return'});

