# passwd-lib.pl
# Common functions for the password module

do '../web-lib.pl';
&init_config();
%access = &get_module_acl();

# can_edit_passwd(&user)
sub can_edit_passwd
{
if ($access{'mode'} == 0) {
	return 1;
	}
elsif ($access{'mode'} == 3) {
	return $_[0]->{'user'} eq $ENV{'REMOTE_USER'};
	}
elsif ($access{'mode'} == 4) {
	return (!$access{'low'} || $_[0]->{'uid'} >= $access{'low'}) &&
	       (!$access{'high'} || $_[0]->{'uid'} <= $access{'high'});
	}
else {
	local $idx = &indexof($_[0]->{'user'}, split(/\s+/, $access{'users'}));
	return $access{'mode'} == 1 && $idx >= 0 ||
	       $access{'mode'} == 2 && $idx < 0;
	}
}

1;

