#!/usr/local/bin/perl
# save_passwd.cgi
# Change a user's password

require './passwd-lib.pl';
&foreign_require("useradmin", "user-lib.pl");
&error_setup($text{'passwd_err'});
&ReadParse();

# Find the user
@ulist = &foreign_call("useradmin", "list_users");
$user = $ulist[$in{'idx'}];
$user || &error($text{'passwd_euser'});
&can_edit_passwd($user) || &error($text{'passwd_ecannot'});

# Validate inputs
if ($access{'old'} == 1 ||
    $access{'old'} == 2 && $user->{'user'} ne $ENV{'REMOTE_USER'}) {
	crypt($in{'old'}, $user->{'pass'}) eq $user->{'pass'} ||
		&error($text{'passwd_eold'});
	}
if ($access{'repeat'}) {
	$in{'new'} eq $in{'repeat'} || &error($text{'passwd_erepeat'});
	}

# Do the change!
&foreign_call("useradmin", "lock_user_files");
$user->{'olduser'} = $user->{'user'};
$user->{'pass'} = &foreign_call("useradmin", "encrypt_password", $in{'new'});
$user->{'passmode'} = 3;
$user->{'plainpass'} = $in{'new'};
$ENV{'USERADMIN_USER'} = $user->{'user'};
$ENV{'USERADMIN_ACTION'} = 'MODIFY_USER';
&foreign_call("useradmin", "making_changes");
&foreign_call("useradmin", "modify_user", $user, $user);
&foreign_call("useradmin", "made_changes");
if ($access{'others'}) {
	&foreign_call("useradmin", "other_modules",
		      "useradmin_modify_user", $user);
	}
&foreign_call("useradmin", "unlock_user_files");
&webmin_log("passwd", undef, $user->{'user'}, $user);

# Show a confirmation message
&header($text{'passwd_title'}, "");
print "<hr>\n";
print "<p>",&text('passwd_ok', "<tt>$user->{'user'}</tt>"),"<p>\n";
print "<hr>\n";
&footer("", $text{'index_return'});

