#!/usr/local/bin/perl
# edit_proc.cgi
# Display information about a process

require './proc-lib.pl';
use Config;
$access{'edit'} || &error($text{'edit_ecannot'});
&header($text{'edit_title'}, "", "edit_proc");
print "<hr>\n";
%pinfo = &process_info($ARGV[0]);
if (!%pinfo) {
	print "<b>$text{'edit_gone'}</b> <p>\n";
	print "<hr>\n";
	&footer("", $text{'index_return'});
	exit;
	}

print "<table border width=100%>\n";
print "<tr $tb> <td><b>$text{'edit_title'}</b></td> </tr>\n";
print "<tr $cb> <td><table width=100%>\n";

print "<tr> <td width=20% nowrap><b>$text{'command'}</b></td>\n";
print "     <td colspan=3><font size=+1>",&cut_string($pinfo{args}, 60),
      "</font></td> </tr>\n";
print "<tr> <td width=20% nowrap><b>$text{'pid'}</b></td><td>$pinfo{pid}</td>\n";
print "<td width=20% nowrap><b>$text{'parent'}</b></td>\n";
if ($pinfo{ppid}) {
	local %ppinfo = &process_info($pinfo{ppid});
	print "<td><a href=\"edit_proc.cgi?$ppinfo{pid}\">",
		&cut_string($ppinfo{'args'},30),"</a></td>";
	}
else { print "<td>$text{'edit_none'}</td>"; }
print " </tr>\n";
print "<tr> <td width=20% nowrap><b>$text{'owner'}</b></td> ",
      "<td>$pinfo{'user'}</td>\n";
print "<td width=20% nowrap><b>$text{'cpu'}</b></td> ",
      "<td>$pinfo{'cpu'}</td> </tr>\n";
print "<tr> <td width=20% nowrap><b>$text{'size'}</b></td> ",
      "<td>$pinfo{'size'}</td>\n";
print "<td width=20% nowrap><b>$text{'runtime'}</b></td> ",
      "<td>$pinfo{'time'}</td> </tr>\n";
print "<tr> <td>",&hlink("<b>$text{'nice'}</b>","nice"),"</td>\n";
print "<form action=renice_proc.cgi>\n";
print "<input type=hidden name=pid value=$ARGV[0]>\n";
print "<td colspan=3>\n";
if (&indexof($pinfo{nice}, @nice_range) < 0) {
	print $pinfo{nice};
	}
else {
	print "<select name=nice>\n";
	for($i=0; $i<@nice_range; $i++) {
		printf "<option value=%d %s>%d%s\n",
			$nice_range[$i],
			$pinfo{nice} == $nice_range[$i] ? "selected" : "",
			$nice_range[$i],
			$i==0 ? " ($text{'edit_prihigh'})" :
			$i==@nice_range-1 ? " ($text{'edit_prilow'})" :
			$nice_range[$i]==0 ? " ($text{'edit_pridef'})" : "";
		}
	print "</select> <input type=submit value='$text{'edit_change'}'>\n";
	}
print "</td> </form></tr>\n";
$i = 0;
foreach $k (keys %pinfo) {
	if ($k =~ /^_/) {
		if ($i%2 == 0) { print "<tr>\n"; }
		printf "<td width=20%% nowrap><b>%s</b></td>\n",
			$info_arg_map{$k};
		print "<td>$pinfo{$k}</td>\n";
		if ($i%2 == 1) { print "<tr>\n"; }
		$i++;
		}
	}
print "</table></td></tr></table><p>\n";

if ($access{'simple'}) {
	# Just display buttons for common signals
	print "<form action=kill_proc.cgi>\n";
	print "<input type=hidden name=pid value=$pinfo{pid}>\n";
	foreach $s ('KILL', 'TERM', 'HUP', 'STOP', 'CONT') {
		printf "<input type=submit value=\"%s\" name=%s>\n",
			$text{"kill_".lc($s)}, $s;
		}
	print "</form>\n";
	}
else {
	# Allow the sending of any signal
	print "<form action=kill_proc.cgi>\n";
	print "<input type=submit value=\"$text{'edit_kill'}\">\n";
	print "<input type=hidden name=pid value=$pinfo{pid}>\n";
	print "<select name=signal>\n";
	foreach $s (split(/\s+/, $Config{sig_name})) {
		printf "<option value=\"$s\" %s> $s\n",
			$s eq "TERM" ? "selected" : "";
		}
	print "</select></form>\n";
	}

@sub = grep { $_->{'ppid'} == $pinfo{pid} } &list_processes();
if (@sub) {
	print "<table border width=100%>\n";
	print "<tr $tb> <td><b>$text{'edit_sub'}</b></td> </tr>\n";
	print "<tr $cb> <td><table>\n";
	@sub = sort { $a->{'pid'} <=> $b->{'pid'} } @sub;
	foreach $s (@sub) {
		local $p = $s->{'pid'};
		print "<tr> <td><a href=\"edit_proc.cgi?$p\">$p</a></td>\n";
		print "<td>",&cut_string($s->{args}, 80),"</td> </tr>\n";
		}
	print "</table></td></tr></table><p>\n";
	}

print "<hr>\n";
&footer("", $text{'index_return'});

