# freebsd-lib.pl
# Functions for parsing freebsd ps output

sub list_processes
{
local($pcmd, $line, $i, %pidmap, @plist);
$pcmd = @_ ? "-p $_[0]" : "";
open(PS, "ps -axwwww -o pid,ppid,user,vsz,%cpu,time,nice,tty,ruser,rgid,pgid,lstart,lim,command $pcmd |");
for($i=0; $line=<PS>; $i++) {
	chop($line);
	if ($line =~ /ps -axwwww/ || $line =~ /^\s*PID/) { $i--; next; }
	$line =~ /^\s*(\d+)\s+(\d+)\s+(\S+)\s+(\d+)\s+([\d\.]+)\s+(\S+)\s+(-?\d+)\s+(\S+)\s+(\S+)\s+(\d+)\s+(\d+)\s+(-|\S+\s+\S+\s+\d+\s+\S+\s+\d+)\s+(\S+)\s+(.*)$/;

	$plist[$i]->{"pid"} = $1;
	$plist[$i]->{"ppid"} = $2;
	$plist[$i]->{"user"} = $3;
	$plist[$i]->{"size"} = "$4 kB";
	$plist[$i]->{"cpu"} = $5;
	$plist[$i]->{"time"} = $6;
	$plist[$i]->{"nice"} = $7;
	$plist[$i]->{"_tty"} = $8;
	$plist[$i]->{"_ruser"} = $9;
	$plist[$i]->{"_rgroup"} = getgrgid($10);
	$plist[$i]->{"_pgid"} = $11;
	$plist[$i]->{"_lstart"} = $12;
	$plist[$i]->{"_lim"} = $13 eq "-" ? "Unlimited" : $13;
	$plist[$i]->{"args"} = $14;
	}
close(PS);
return @plist;
}

# renice_proc(pid, nice)
sub renice_proc
{
$out = `renice $_[1] -p $_[0] 2>&1`;
if ($?) { return $out; }
return undef;
}

foreach $ia (keys %text) {
	if ($ia =~ /^freebsd(_\S+)/) {
		$info_arg_map{$1} = $text{$ia};
		}
	}

@nice_range = (-20 .. 20);

$has_fuser_command = 0;

1;

