#!/usr/local/bin/perl
# Display a list of other webmin servers

require './servers-lib.pl';
&header($text{'index_title'}, "", undef, 1, 1);
print "<hr>\n";

@servers = grep { &can_use_server($_) }
	   sort { $a->{'host'} cmp $b->{'host'} } &list_servers();
if (@servers) {
	if ($access{'edit'}) {
		@titles = map { &make_iconname($_)."</a> <a href='edit_serv.cgi?id=$_->{'id'}'>(".$text{'index_edit'}.")" } @servers;
		}
	else {
		@titles = map { &make_iconname($_) } @servers;
		}
	@icons = map { "images/$_->{'type'}.gif" } @servers;
	@links = map { $_->{'user'} ? "link.cgi/$_->{'id'}/"
				    : &make_url($_) } @servers;
	&icons_table(\@links, \@titles, \@icons, undef, "target=_top");
	}
else {
	print "<b>$text{'index_none'}</b> <p>\n";
	}

print "<a href='edit_serv.cgi?new=1'>$text{'index_add'}</a> <p>\n"
    if $access{'edit'};

print "<hr>\n",
    "<table width=100%>\n",
    "<form action=find.cgi>\n",
    "<tr> <td><input type=submit value=\"$text{'index_broad'}\"></td>\n",
    "<td>$text{'index_findmsg'}</td> </tr>\n",
    "</form>\n",
    "<form action=find.cgi>\n",
    "<tr> <td><input type=submit value=\"$text{'index_scan'}\"></td>\n",
    "<td>",&text('index_scanmsg','<input name=scan size=15>'),"</td> </tr>\n",
    "</form>\n",
    "</table>\n"
    if $access{'find'};

print "<hr>\n";
&footer("/", $text{'index'});

sub make_url
{
return sprintf "http%s://%s:%d/",
	$_[0]->{'ssl'} ? 's' : '', $_[0]->{'host'}, $_[0]->{'port'};
}

sub make_iconname
{
if ($_[0]->{'desc'}) {
	return $_[0]->{'desc'};
	}
else {
	return "$_[0]->{'host'}:$_[0]->{'port'}";
	}
}

