#!/usr/local/bin/perl
# index.cgi
# Show the shell user interface

require './shell-lib.pl';
%access = &get_module_acl();
&ReadParse();
&header($text{'index_title'}, "", undef, 0, 1, undef, undef, undef,
	"onLoad='window.scroll(0, 10000); document.forms[0].cmd.focus()'");
print "<hr>\n";

$pwd = $in{'pwd'} ? $in{'pwd'} : "/";
if (!$in{'clear'}) {
	$history = &un_urlize($in{'history'});
	if ($in{'cmd'}) {
		# Execute the latest command
		chdir($pwd);
		$history .= "<b>&gt; $in{'cmd'}</b>\n";
		if ($in{'cmd'} =~ /^cd\s+(.*)$/) {
			if (!chdir($1)) {
				$history .= "$1: $!\n";
				}
			else {
				chop($pwd = `pwd`);
				}
			}
		else {
			if ($access{'user'} eq 'root') {
				$out = `($in{'cmd'}) 2>&1`;
				}
			else {
				$in{'cmd'} =~ s/\\/\\\\/g;
				$in{'cmd'} =~ s/"/\\"/g;
				$in{'cmd'} =~ s/`/\\`/g;
				$out = `su $access{'user'} -c '$in{'cmd'}' 2>&1`;
				}
			$out =~ s/&/&amp;/g;
			$out =~ s/</&lt;/g;
			$out =~ s/>/&gt;/g;
			$history .= $out;
			}
		}
	}

# Show the history and command input
if ($history) {
	print "<table border width=100%>\n";
	print "<tr $tb> <td><b>$text{'index_history'}</b></td> </tr>\n";
	print "<tr $cb> <td><pre>";
	print $history;
	print "</pre></td></tr> </table><p>\n";
	print "<hr>\n";
	}

print "$text{'index_desc'}<br>\n";
print "<form action=index.cgi method=post>\n";
print "<table width=100%><tr>\n";
print "<td><input type=submit value='$text{'index_ok'}'>\n";
print "<input name=cmd size=50></td>\n";
print "<td align=right><input type=submit name=clear ",
      "value='$text{'index_clear'}'></td>\n";
print "</tr> </table>\n";
print "<input type=hidden name=pwd value='$pwd'>\n";
print "<input type=hidden name=history value='",&urlize($history),"'>\n";
print "</form>\n";

print "<hr>\n";
&footer("/", $text{'index'});

