# bind8-monitor.pl
# Monitor the BIND DNS server on this host

# Check the PID file to see if apache is running
sub get_bind8_status
{
&foreign_require($_[1], "bind8-lib.pl");
local %bconfig = &foreign_config($_[1]);
return { 'up' => -1 } if (!-r $bconfig{'chroot'}.$bconfig{'named_conf'});
local $conf = &foreign_call($_[1], "get_config");
local $opts = &foreign_call($_[1], "find", "options", $conf);
local $pidopt = &foreign_call($_[1], "find", "pid-file", $opts->{'members'});
local $file = $pidopt ? $pidopt->{'value'} :
	      $bconfig{'pid_file'} ? $bconfig{'pid_file'} :
	      "/var/run/named.pid";
$file = $bconfig{'chroot'}.$file;

if (open(PID, $file) && <PID> =~ /(\d+)/ && kill(0, $1)) {
	close(PID);
	local @st = stat($file);
	return { 'up' => 1,
		 'desc' => &text('up_since', scalar(localtime($st[9]))) };
	}
else {
	return { 'up' => 0 };
	}
}

sub parse_bind8_dialog
{
&depends_check($_[0], "bind8");
}

1;

