# http-monitor.pl
# Monitor a remote HTTP server

sub get_http_status
{
# Connect to the server
socket(SOCK, PF_INET, SOCK_STREAM, getprotobyname("tcp")) ||
	return { 'up' => -1 };
local $addr = inet_aton($_[0]->{'host'});
return { 'up' => -1 } if (!$addr);
local $st = time();
$SIG{'ALRM'} = "http_connect_timeout";
alarm($_[0]->{'alarm'} ? $_[0]->{'alarm'} : 10);
connect(SOCK, sockaddr_in($_[0]->{'port'}, $addr)) ||
	return { 'up' => 0 };
select(SOCK); $| = 1; select(STDOUT);

# Request a page
print SOCK "HEAD $_[0]->{'page'} HTTP/1.0\r\n";
print SOCK "Host: $_[0]->{'host'}\r\n";
print SOCK "User-agent: Webmin\r\n";
print SOCK "\r\n";
local $line = <SOCK>;
local $up = $line =~ /^HTTP\/1\..\s+200\s+/ ? 1 : 0;
close(SOCK);
alarm(0);
return { 'up' => $up,
	 'time' => time() - $st };
}

sub http_connect_timeout
{
}

sub show_http_dialog
{
print "<tr> <td><b>$text{'http_url'}</b></td>\n";
printf "<td><input name=url size=40 value='%s'></td>\n",
 $_[0]->{'host'} ? "http://$_[0]->{'host'}:$_[0]->{'port'}$_[0]->{'page'}"
		 : "http://";

print "<td><b>$text{'http_alarm'}</b></td>\n";
printf "<td><input type=radio name=alarm_def value=1 %s> %s\n",
	$_[0]->{'alarm'} ? '' : 'checked', $text{'default'};
printf "<input type=radio name=alarm_def value=0 %s>\n",
	$_[0]->{'alarm'} ? 'checked' : '';
print "<input name=alarm size=5 value='$_[0]->{'alarm'}'></td> </tr>\n";
}

sub parse_http_dialog
{
if ($in{'url'} =~ /^http:\/\/([^:]+):(\d+)(\/.*)$/) {
	$_[0]->{'host'} = $1;
	$_[0]->{'port'} = $2;
	$_[0]->{'page'} = $3;
	}
elsif ($in{'url'} =~ /http:\/\/([^\/]+)(\/.*)$/) {
	$_[0]->{'host'} = $1;
	$_[0]->{'port'} = 80;
	$_[0]->{'page'} = $2;
	}
else {
	&error($text{'http_eurl'});
	}

if ($in{'alarm_def'}) {
	delete($_[0]->{'alarm'});
	}
else {
	$in{'alarm'} =~ /^\d+$/ || &error($text{'http_ealarm'});
	$_[0]->{'alarm'} = $in{'alarm'};
	}
}

