#!/usr/local/bin/perl
# monitor.pl
# Check all the monitors and send email if something is down

$no_acl_check++;
require './status-lib.pl';

# Check if the monitor should be run now
@tm = localtime(time());
@hours = split(/\s+/, $config{'sched_hours'});
!@hours || &indexof($tm[2], @hours) >= 0 || exit;
@days = split(/\s+/, $config{'sched_days'});
!@days || &indexof($tm[6], @days) >= 0 || exit;

# Check for services that are down
&read_file("$module_config_directory/oldstatus", \%oldstatus);
$now = localtime(time());
$host = &get_system_hostname();
foreach $serv (&list_services()) {
	if ($serv->{'nosched'}) {
		delete($oldstatus{$serv->{'id'}});
		next;
		}
	$stat = &service_status($serv);
	$o = $oldstatus{$serv->{'id'}};
	if ($config{'sched_warn'} == 0 && $stat->{'up'} == 0 && $o) {
		# Service has just gone down
		$email .= "Monitor on $host for '$serv->{'desc'}'\n".
		 "has detected that the service is down at $now\n\n";
		$subj = "$serv->{'desc'} down on $host";
		if ($serv->{'ondown'}) {
			system("($serv->{'ondown'}) >/dev/null 2>&1");
			}
		}
	elsif ($config{'sched_warn'} == 1 && $stat->{'up'} != $o &&
	       (defined($o) || $stat->{'up'} == 0)) {
		# Service has changed status
		if ($stat->{'up'} == 0) {
			$email .= "Monitor on $host for '$serv->{'desc'}'\n".
			 "has detected that the service is down at $now\n\n";
			$subj = "$serv->{'desc'} down on $host";
			if ($serv->{'ondown'}) {
				system("($serv->{'ondown'}) >/dev/null 2>&1");
				}
			}
		elsif ($stat->{'up'} == 1) {
			$email .= "Monitor on $host for '$serv->{'desc'}'\n".
			 "has detected that the service is back up at $now\n\n";
			$subj = "$serv->{'desc'} back up on $host";
			if ($serv->{'onup'}) {
				system("($serv->{'onup'}) >/dev/null 2>&1");
				}
			}
		}
	$oldstatus{$serv->{'id'}} = $stat->{'up'};
	if ($config{'sched_single'} && $email) {
		# Force the sending of one email per report
		&send_status_email($email, $subj);
		undef($email);
		}
	}
&write_file("$module_config_directory/oldstatus", \%oldstatus);

# Send the email if necessary
if ($email) {
	&send_status_email($email, 'Service monitor');
	}

# send_status_email(text, subject)
sub send_status_email
{
return if (!$config{'sched_email'});
local %sconfig = &foreign_config("sendmail");
if ($config{'sched_from'}) {
	open(MAIL, "|$sconfig{'sendmail_path'} -t -f$config{'sched_from'}");
	print MAIL "From: $config{'sched_from'}\n";
	}
else {
	open(MAIL, "|$sconfig{'sendmail_path'} -t");
	print MAIL "From: webmin\n";
	}
print MAIL "To: $config{'sched_email'}\n";
print MAIL "Subject: $_[1]\n";
print MAIL "\n";
print MAIL $_[0];
close(MAIL);
}

