#!/usr/local/bin/perl

require "./time-lib.pl";

local ($rawdate, $rawhwdate, %system_date, $rawtime, %hw_date, $txt);
$txt = "";

&error( $text{ 'acl_error' } ) if( $access{ 'sysdate' } && $access{ 'hwdate' } );
&error( &text( 'error_cnf', "<tt>date</tt>" ) ) if( !$access{'sysdate'} && !&has_command( "date" ) );
&error( &text( 'error_cnf', "<tt>hwclock</tt>" ) ) if( !$access{'hwdate'} && $config{'hwtime'} && !&has_command( "hwclock" ) );

&header( $text{ 'index_title' }, "", "index", 1, 1, undef,
	&help_search_link("date hwclock", "man"));
print( "<hr>" );

if( !$access{'sysdate'} )
{
  $rawdate = `date`;
  chop( $rawdate );
  $rawdate =~ s/ {1,}/ /g;

  ( $system_date{ 'day' }, $system_date{ 'month' }, $system_date{ 'date' }, $rawtime, $_, $system_date{ 'year' } ) = split( / /, $rawdate );
  ( $system_date{ 'hour' }, $system_date{ 'minute' }, $system_date{ 'second' } ) = split( /:/, $rawtime );

  print( 
"<p><form action=apply.cgi>",
  &tabletime( &hlink( $text{ 'sys_title' }, "system_time" ), %system_date ),
  "<input type=submit name=action value=\"", $text{ 'action_apply' }, "\">",
  $config{'hwtime'} ? " <input type=submit name=action value=\"".$text{ 'action_sync_s' }."\">" : "", "</form>" );
}

if( !$access{'hwdate'} && $config{'hwtime'} )
{
  $rawhwdate = `hwclock`;
  $rawhwdate =~ s/ {1,}/ /g;

  ( $hw_date{ 'day' }, $hw_date{ 'month' }, $hw_date{ 'date' }, $rawtime, $hw_date{ 'year' } ) = split( / /, $rawhwdate );
  ( $hw_date{ 'hour' }, $hw_date{ 'minute' }, $hw_date{ 'second' } ) = split( /:/, $rawtime );

  if( !$access{ 'sysdate' } )
  {
    $hw_date{ 'second' } = $system_date{ 'second' } if( $hw_date{ 'second' } - $system_date{ 'second' } <= $config{ 'lease' } );
  }
    
print( 
"<p><form action=apply.cgi>",
  &tabletime( &hlink( $text{ 'hw_title' }, "hardware_time" ), %hw_date ),
  "<input type=submit name=action value=\"", $text{ 'action_save' }, "\">",
  " <input type=submit name=action value=\"", $text{ 'action_sync' }, "\">",
"</form><p>" );
}

if( ( !$access{ 'sysdate' } && &has_command( "date" ) ) || ( !$access{ 'hwdate' } && &has_command( "hwclock" ) ) )
{
  print(
"<form action=apply.cgi>",
  "<table nosave border width=\"100%\">",
	"<tr ", $tb, ">",
	  "<td><b>", &hlink( $text{ 'index_timeserver' }, "timeserver" ), "</b></td>",
	"</tr><tr ", $cb, ">",
	  "<td>",
		$text{ 'index_address' }, " ",
  		&p_entry( "timeserver", $config{'timeserver'}, 30 ),
		" <input type=submit name=action value=\"", $text{ 'action_timeserver_sys' }, "\">",
		$config{'hwtime'} ? "<input type=submit name=action value=\"$text{ 'action_timeserver_hw' }\">" : "",
	  "</td>",
	"</tr>",
  "</table>",
"</form>" );
}

#if ($zonelink = readlink($config{'zonelink'})) {
#	print "<form action=savezone.cgi>\n";
#	print "<table border width=100%>\n";
#	print "<tr $tb> <td><b>$text{'index_zone'}</b></td> </tr>\n";
#	print "<tr $cb> <td valign=top>$text{'index_tz'}\n";
#	print "<select name=zone size=5>\n";
#	open(TAB, $config{'zonetab'});
#	while(<TAB>) {
#		s/\r|\n//g;
#		s/#.*$//;
#		if (/^(\S+)\s+(\S+)\s+(\S+)\s*(.*)/) {
#			printf "<option %s>%s\n",
#				"$config{'zonedir'}/$3" eq $zonelink
#					? "selected" : "", $3;
#			}
#		}
#	close(TAB);
#	print "</select></td> </tr>\n";
#	print "</table>\n";
#	print "<input type=submit value='$text{'action_savezone'}'>\n";
#	print "</form>\n";
#	}

print "<hr>\n";
&footer( "/", $text{ 'index' } );

sub tabletime
{
  my ( $label, %src ) = @_,
  %assoc_day = ( "Mon", $text{ 'day_1' }, "Tue", $text{ 'day_2' }, "Wed", $text{ 'day_3' }, "Thu", $text{ 'day_4' }, "Fri", $text{ 'day_5' }, "Sat", $text{ 'day_6' }, "Sun", $text{ 'day_0' } ),
  %assoc_month = ( "Jan", $text{ 'month_1' }, "Feb", $text{ 'month_2' }, "Mar", $text{ 'month_3' }, "Apr", $text{ 'month_4' }, "May", $text{ 'month_5' }, "Jun", $text{ 'month_6' }, "Jul", $text{ 'month_7' }, "Aug", $text{ 'month_8' }, "Sep", $text{ 'month_9' }, "Oct", $text{ 'month_10' }, "Nov", $text{ 'month_11' }, "Dec", $text{ 'month_12' } );

  return
"<table nosave border width=\"100%\"><tr ". $tb. "><td>". $label. "</td></tr></table>\n".
"<table nosave border width=\"100%\">".
  "<tr ". $cb. ">".
	"<td nosave><b>". $text{ 'day' }. "</b></td>\n".
	"<td nosave><b>". $text{ 'date' }. "</b></td>\n".
	"<td nosave><b>". $text{ 'month' }. "</b></td>\n".
	"<td nosave><b>". $text{ 'year' }. "</b></td>\n".
	"<td><b>". $text{ 'hour' }. "</b></td>\n".
  "</tr>\n<tr ". $cb. ">".
	"<td>". $assoc_day{ $src{ 'day' } }."</td>\n".
	"<td>". &p_select( "date", $src{ 'date' }, ( 1..31 ) ). "</td>\n".
	"<td>". &p_select_wdl( "month", $assoc_month{ $src{ 'month' } }, "01",( $text{ 'month_1' }, "02", $text{ 'month_2' }, "03", $text{ 'month_3' }, "04", $text{ 'month_4' }, "05", $text{ 'month_5' }, "06", $text{ 'month_6' }, "07", $text{ 'month_7' }, "08", $text{ 'month_8' }, "09", $text{ 'month_9' }, "10", $text{ 'month_10' }, "11", $text{ 'month_11' }, "12", $text{ 'month_12' } ) ). "</td>\n".
	"<td>". &p_select( "year", $src{ 'year' }, ( 1969..2037 ) ). "</td>\n".
	"<td>". &p_select( "hour", $src{ 'hour' }, ( "00", "01", "02", "03", "04", "05", "06", "07", "08", "09", 10..23 ) ). "\n:". &p_select( "minute", $src{ 'minute' }, ( "00", "01", "02", "03", "04", "05", "06", "07", "08", "09", 10..59) ). ":". &p_select( "second", $src{ 'second' }, ( "00", "01", "02", "03", "04", "05", "06", "07", "08", "09", 10..59 ) ). "</td>\n".
  "</tr>\n".
"</table>";
}
