#!/usr/local/bin/perl
# delete_mod.cgi
# Delete selected modules from webmin, without asking

require './webmin-lib.pl';
&ReadParse();
&error_setup($text{'delete_err'});
@mods = split(/\0/, $in{'mod'});

# ask the user if he is sure
if (!$in{'confirm'}) {
	&header($text{'delete_title'}, "");
	print "<hr>\n";
	print "<p><form action=delete_mod.cgi>\n";
	foreach $m (@mods) {
		local %minfo = &get_module_info($m);
		print "<input type=hidden name=mod value=$m>\n";
		$total += &disk_usage_kb("../$m") if (!-l "../$m");
		$descs .= " , " if ($descs);
		$descs .= "<b>$minfo{'desc'}</b>";
		}
	print "<center>",&text('delete_rusure', int($total), $descs),"<p>",
	      "<input type=submit name=confirm value='$text{'delete'}'>",
	      "</form></center><hr>\n";
	&footer("", $text{'index_return'});
	exit;
	}

# check if any other module depends on those to be deleted
opendir(DIR, "..");
while($m = readdir(DIR)) {
	local %minfo;
	if (%minfo = &get_module_info($m) && &check_os_support(\%minfo)) {
		foreach $d (split(/\s+/, $minfo{'depends'})) {
			$depends{$d} = $minfo{'desc'};
			}
		}
	}
closedir(DIR);
foreach $m (@mods) {
	%minfo = &get_module_info($m);
	if (!-l "../$m" && $depends{$m}) {
		&error(&text('delete_edep', "<tt>$minfo{'desc'}</tt>",
			     "<tt>$depends{$m}</tt>"));
		}
	}

# delete the selected modules
foreach $m (split(/\0/, $in{'mod'})) {
	next if (!$m || !-d "../$m");
	local (%minfo, %cinfo);
	%minfo = &get_module_info($m);
	if ($minfo{'clone'}) {
		# Deleting a clone
		&read_file("$config_directory/$m/clone", \%cinfo);
		unlink("../$m");
		system("rm -rf $config_directory/$m");
		push(@mdesc, &text('delete_desc1', $minfo{'desc'},
				   $minfo{'clone'}));
		}
	else {
		# Delete any clones of this module
		local @mst = stat("../$m");
		opendir(DIR, "..");
		foreach $l (readdir(DIR)) {
			@lst = stat("../$l");
			if (-l "../$l" && $lst[1] == $mst[1]) {
				unlink("../$l");
				system("rm -rf $config_directory/$l");
				}
			}
		closedir(DIR);

		open(TYPE, "../$m/install-type");
		chop($type = <TYPE>);
		close(TYPE);

		# Deleting the real module
		chop($pwd = `cd ../$m ; pwd`);
		local $size = &disk_usage_kb("../$m");
		push(@mdesc, &text('delete_desc2', "<b>$minfo{'desc'}</b>",
				   "<tt>$pwd</tt>", $size));
		if ($type eq 'rpm') {
			# This module was installed from an RPM .. rpm -e it
			system("rpm -e wbm-$m");
			}
		else {
			# Module was installed from a .wbm file .. just rm it
			system("rm -rf ../$m");
			}
		}
	&webmin_log("delete", undef, $m, { 'desc' => $minfo{'desc'} });
	}

&header($text{'delete_title'}, "");
print "<hr>\n";
print $text{'delete_msg'},"<p>\n";
print "<ul>\n";
for($i=0; $i<@mdesc; $i++) {
	print $mdesc[$i],"<p>\n";
	}
print "</ul><p>\n";
print "<hr>\n";
&footer("", $text{'index_return'});

