#!/usr/local/bin/perl
# upgrade.cgi
# Upgrade webmin if possible

require './webmin-lib.pl';
&ReadParseMime();

if ($in{'source'} == 0) {
	# from local file
	&error_setup(&text('upgrade_err1', $in{'file'}));
	$file = $in{'file'};
	if (!(-r $file)) { &error($text{'upgrade_efile'}); }
	}
elsif ($in{'source'} == 1) {
	# from uploaded file
	&error_setup($text{'upgrade_err2'});
	$file = &tempname();
	$need_unlink = 1;
	if ($no_upload) {
                &error($text{'upgrade_ebrowser'});
                }
	open(MOD, "> $file");
	print MOD $in{'upload'};
	close(MOD);
	}
elsif ($in{'source'} == 2) {
	# find latest version at www.webmin.com by looking at index page
	&error_setup(&text('upgrade_err3', $in{'url'}));
	$file = &tempname();
	&http_download('www.webmin.com', 80, '/webmin/', $file);
	open(FILE, $file);
	while(<FILE>) {
		if (/webmin-([0-9\.]+)\.tar\.gz/) {
			$version = $1;
			last;
			}
		}
	close(FILE);
	unlink($file);
	if ($version <= &get_webmin_version()) {
		&error(&text('upgrade_eversion', $version));
		}
	if ($in{'mode'} eq 'rpm') {
		&http_download('www.webmin.com', 80,
		  "/webmin/download/rpm/webmin-$version.rpm",$file);
		}
	elsif ($in{'mode'} eq 'solaris-pkg') {
		&http_download('www.webmin.com', 80,
		  "/webmin/download/solaris-pkg/webmin-$version.pkg.gz",$file);
		}
	else {
		&http_download('www.webmin.com', 80,
		  "/webmin/download/webmin-$version.tar.gz",$file);
		}
	$need_unlink = 1;
	}
elsif ($in{'source'} == 3) {
	# Get the latest version from Caldera with cupdate
	&redirect("/cupdate/");
	}

# gunzip the file if needed
open(FILE, $file);
read(FILE, $two, 2);
close(FILE);
if ($two eq "\037\213") {
	if (!&has_command("gunzip")) {
		unlink($file) if ($need_unlink);
		&error($text{'upgrade_egunzip'});
		}
	$newfile = &tempname();
	system("gunzip -c $file >$newfile 2>/dev/null");
	unlink($file) if ($need_unlink);
	$need_unlink = 1;
	$file = $newfile;
	}

if ($in{'mode'} eq 'rpm') {
	# Check if it is an RPM package
	$out = `rpm -qp $file`;
	$out =~ /^webmin-(\d+\.\d+)/ ||
		&error($text{'upgrade_erpm'});
	if ($1 <= &get_webmin_version()) {
		&error(&text('upgrade_eversion', "$1"));
		}

	# Install the RPM
	$| = 1;
	&header($text{'upgrade_title'}, "");
	print "<hr>\n";
	print "<p>",$text{'upgrade_setuprpm'},"<p>\n";
	if ($need_unlink) {
		system("(rpm -U --ignoreos --ignorearch $file ; rm -f $file) >/dev/null 2>/dev/null </dev/null &");
		}
	else {
		system("(rpm -U --ignoreos --ignorearch $file) >/dev/null 2>/dev/null </dev/null &");
		}
	}
elsif ($in{'mode'} eq 'solaris-pkg') {
	# Check if it is a solaris package
	&foreign_require("software", "software-lib.pl");
	&foreign_call("software", "is_package", $file) ||
		&error($text{'upgrade_epackage'});
	local @p = &foreign_call("software", "file_packages", $file);
	$p[0] =~ /^WSwebmin/ || &error($text{'upgrade_epackage'});

	# Install the package
	$| = 1;
	&header($text{'upgrade_title'}, "");
	print "<hr>\n";
	print "<p>",$text{'upgrade_setuppackage'},"<p>\n";
	$ENV{'KEEP_ETC_WEBMIN'} = 1;
	if (!fork()) {
		chdir("/");
		close(STDIN); close(STDOUT); close(STDERR);
		$rv = &foreign_call("software", "delete_package", "WSwebmin");
		$software::in{'root'} = '/';
		$rv = &foreign_call("software", "install_package", $file, "WSwebmin");
		unlink($file) if ($need_unlink);
		exit;
		}
	}
elsif ($in{'mode'} eq 'caldera') {
	# Check if it is a Caldera RPM of Webmin
	$out = `rpm -qp $file`;
	$out =~ /^webmin-(\d+\.\d+)/ ||
		&error($text{'upgrade_erpm'});
	if ($1 <= &get_webmin_version()) {
		&error(&text('upgrade_eversion', "$1"));
		}
	local $wfound = 0;
	open(OUT, "rpm -qpl $file |");
	while(<OUT>) {
		$wfound++ if (/^\/etc\/webmin/);
		}
	close(OUT);
	$wfound || &error($text{'upgrade_ecaldera'});

	# Install the RPM
	$| = 1;
	&header($text{'upgrade_title'}, "");
	print "<hr>\n";
	print "<p>",$text{'upgrade_setuprpm'},"<p>\n";
	if ($need_unlink) {
		system("(rpm -U --ignoreos --ignorearch $file ; rm -f $file) >/dev/null 2>/dev/null </dev/null &");
		}
	else {
		system("(rpm -U --ignoreos --ignorearch $file) >/dev/null 2>/dev/null </dev/null &");
		}
	}
else {
	# Check if it is a webmin tarfile
	open(TAR, "tar tf $file 2>&1 |");
	while(<TAR>) {
		if (/^webmin-([0-9\.]+)\//) {
			$version = $1;
			}
		if (/^[^\/]+\/(\S+)$/) {
			$hasfile{$1}++;
			}
		}
	close(TAR);
	if (!$version) {
		unlink($file) if ($need_unlink);
		if ($hasfile{'module.info'}) {
			&error(&text('upgrade_emod', 'edit_mods.cgi'));
			}
		else {
			&error($text{'upgrade_etar'});
			}
		}
	if ($version <= &get_webmin_version()) {
		&error(&text('upgrade_eversion', $version));
		}

	# Extract it next to the current directory and run setup.sh
	$| = 1;
	&header($text{'upgrade_title'}, "");
	print "<hr>\n";
	system("cd ../.. ; tar xf $file >/dev/null 2>&1");
	unlink($file) if ($need_unlink);
	$ENV{'config_dir'} = $config_directory;
	$ENV{'webmin_upgrade'} = 1;
	$ENV{'autothird'} = 1;
	print "<p>",$text{'upgrade_setup'},"<p>\n";
	system("(cd ../../webmin-$version ; ./setup.sh) >/dev/null 2>/dev/null </dev/null &");
	}
&webmin_log("upgrade", undef, undef, { 'version' => $version,
				       'mode' => $in{'mode'} });

print "<hr>\n";
&footer("", $text{'index_return'});

