# log_parser.pl
# Functions for parsing this module's logs

require './xinetd-lib.pl';

# parse_webmin_log(user, script, action, type, object, &params)
# Converts logged information from this module into human-readable form
sub parse_webmin_log
{
local ($user, $script, $action, $type, $object, $p, $long) = @_;
if ($type eq 'serv') {
	return &text("log_${action}_serv", "<tt>$object</tt>",
		     uc($p->{'protocol'}));
	}
elsif ($action eq 'start') {
	return $text{'log_start'};
	}
elsif ($action eq 'apply') {
	return $text{'log_apply'};
	}
elsif ($action eq 'defaults') {
	return $text{'log_defaults'};
	}
else {
	return undef;
	}
}

